/**

Interface helper methods to manipulate the channels object.

**/
var debug;
var alerts;

function ChannelsHelper(logs, alerts){
  if(logs === true){
    this.debug = debug = true;
  }else{
    this.debug = debug = false;
  }
  if(alerts == true){
    this.alerts = alerts = true;
  }else{
    this.alerts = alerts = false;
  }
  this.components = [];
  this.properties = [];
  this.channels = [];
}

/**
  Set the profile object.
**/

ChannelsHelper.prototype.getProfileInfo = function(data){
  var profile = {};
  if(!data.profileName || !data.profileId){
    if(self.debug === true){ console.log('There is no profile information.'); }
    if(self.alerts === true){ alert('There is no profile information.'); }
  }
  profile.name = data.profileName;
  profile.id = data.profileId;
  profile.photo = data.backgroundPhotoUrl;
  return profile;
}


/**
  Get channel from component.
**/

ChannelsHelper.prototype.getChannelByComponent = function(componentId){
  var channel =  null;
  var self = this;
  self.components.forEach(function(component){
    if(component.id === componentId){
      channel = component.channel; return channel;
    }
  });
  return channel;
}

/**
  Set the components object, from the given channels objects
**/

ChannelsHelper.prototype.getComponentsFromChannels = function(fchannels){
  var _components=[];
  var self = this;
  if(fchannels === null || fchannels === undefined || fchannels.length < 1){
    if(self.debug === true){ console.log('There is no channel information.'); }
    if(self.alerts === true){ alert('Configuration Errors.'); }
  }
  self.channels = fchannels;
  self.channels.forEach(function(channel){
    var channelComponents = channel.components;
    if(!channelComponents || channelComponents.length < 1){
      if(self.debug === true){ console.log('No components for channel '+channel.remoteId);}
      if(self.alerts === true){ alert('No components for channel '+channel.remoteId); }
      return;
    }
    channelComponents.forEach(function(component){
      _components.push({
        id: component.id,
        type: component.type,
        channel: channel.remoteId,
        profile: channel.profileId,
        label: component.label,
        class: component.classes || null
      });
    });
  });
  self.components = _components;
  return _components;
}


/**
  Return components by the given type.
**/
ChannelsHelper.prototype.getComponentsByType = function(type){
  var _components=[];
  this.components.forEach(function(component){
    if(component.type === type){
      _components.push(component);
    }
  });
  return _components;
}


/**
Set the properties object.
The properties object will have all properties
 x the channels number 
 x the components number
 x the properties number
 x the classes number of the property
**/
ChannelsHelper.prototype.getPropertiesFromChannels = function(supported, removeDuplicats){
  var properties=[];
  var self = this;
  if(self.channels === null || self.channels === undefined || self.channels.length < 1){
    if(self.debug === true){ console.log('There is no channel information.'); }
    if(self.alerts === true){ alert('There is no channel information.'); }
  }

  self.channels.forEach(function(channel){
    var channelProperties = channel.properties;
    
    if(!channelProperties || channelProperties.length < 1){
      if(self.debug){ console.log('No properties for '+channel.remoteId+' channel.'); }
      if(self.alerts === true){ alert('No properties for '+channel.remoteId+' channel.'); }
      return;
    }
    channelProperties.forEach(function(property){
      var propertyComponents = getComponentsIdByType(channel.components, property.components);
      if(propertyComponents.length < 1){
        if(self.debug){ console.log('No valid components for this property.'); }
        if(self.alerts === true){ alert('No valid components for this property.'); }
        return;
      }
      propertyComponents.forEach(function(component){
        var classes = property.classes || property.class;
        if(!classes){
          if(self.debug){ console.log('No classes for '+property.id+'  property.'); }
          if(self.alerts === true){ alert('No classes for '+property.id+'  property.'); }
          return;
        }
        var suportedClasses =[];
        supported.forEach(function(supportedProperty){
          suportedClasses.push(supportedProperty.class);
        });
        if(suportedClasses.length < 1){
          if(self.debug){ console.log('Missed supported classes.');}
          if(self.alerts){ alert('Missed supported classes.'); }
        }
        classes.forEach(function(classs){
          if(suportedClasses.indexOf(classs) === -1){
            if(self.debug){ console.log('Class '+classs+' not supported by this Interface.');}
            if(self.alerts){ alert('Class '+classs+' not supported by this Interface.'); }
            return;
          }else{
            var schema = getSupportedSchemaByClass(classs, supported);
            if(schema.length === 0){
              if(self.debug){ console.log('Schema not defined on the supported schemas.'); }
              if(self.alerts){ alert('Schema not defined on the supported schemas.'); }
              return;
            }else{
              property.schema = checkSchema(property.schema);
              if(schema.indexOf(property.schema) === -1){
                if(self.debug){ console.log('Schema '+property.schema+' not supported by the class.');}
                if(self.alerts){ alert('Schema '+property.schema+' not supported by the class.');}
                property.schema = '';
              }
              properties.push({
                id: property.id,
                class: classs,
                channel: channel.remoteId,
                profile: channel.profileId,
                schema: property.schema,
                component: component,
                io: property.io,
                extension: property.schemaExtension
              });
            }
          }
          
        });
      });
    });
  });

  if(removeDuplicats && removeDuplicats === true){
    if(self.debug){ console.log('Remove properties with duplicated classes'); }
    properties = removeDuplicatedClasses(properties);
  }
  self.properties = properties;
  return properties;
}

ChannelsHelper.prototype.updateProperties = function(properties){
  this.properties = properties;
}

/**
  Returns the schema of the property, from the corresponding component and channel.
**/
ChannelsHelper.prototype.getSchemaByProperty = function(propertyy, component, channel){
  var schema = "";
  this.properties.forEach(function(property){
    if(property.id === propertyy && property.component === component && property.channel === channel){
      schema =  property.schema;
      return schema;
    }
  });
  return schema;
}

/**
  Returns the extension of the property, from the corresponding component and channel.
**/
ChannelsHelper.prototype.getExtensionByProperty = function(propertyy, component, channel){
  var extension = null;
  this.properties.forEach(function(property){
    if(property.id === propertyy && property.component === component && property.channel === channel){
      extension =  property.extension;
      return extension;
    }
  });
  return extension;
}

/**
  Returns the label content of the component.
**/
ChannelsHelper.prototype.getLabelFromComponent = function(componentId){
  var label="";
  this.components.forEach(function(component){
    if(component.id === componentId){
      label = component.label;
      return label;
    }
  });
  return label;
}

/**
  Set property value by class, channel and component.
**/
ChannelsHelper.prototype.setPropertyValueByClass = function(pClass, channelId, componentId, value){
  this.properties.forEach(function(property){
    if(property.class === pClass && property.channel ===  channelId && property.component === componentId){
      property.value = value;
    }
  });
}

/**
  Get property value by class, channel and component.
**/
ChannelsHelper.prototype.getPropertyValueByClass = function(pClass, channelId, componentId){
  var value = null;
  this.properties.forEach(function(property){
    if(property.class === pClass && property.channel ===  channelId && property.component === componentId){
      value = property.value;
      return value;
    }
  });
  return value;
}

/**
  Get class name by property id, channel and component.
**/
ChannelsHelper.prototype.getClassById = function(id, channelId, componentId){
  var classs="";
  this.properties.forEach(function(property){
    if(property.id === id && property.channel ===  channelId && property.component === componentId){
      classs = property.class;
      return classs;
    }
  });
  return classs;
}

/**
  Check if the component exists.
**/
ChannelsHelper.prototype.getComponent = function(componentId){
  var exists = false;
  this.components.forEach(function(component){
    if(component.id === componentId){
      exists = true;
      return exists;
    }
  });
  return exists;
}

/**
  Get component data by the component id.
**/
ChannelsHelper.prototype.getComponentFromId = function(componentId){
  var _component=null;
  this.components.forEach(function(component){
    if(component.id === componentId){
      _component = component;
      return _component;
    }
  });
  return _component;
}

/**
  Get component data by the component id.
**/
ChannelsHelper.prototype.getClassIdByComponent = function(componentId, channelId, propertyClass){
  var _property="";
  this.properties.forEach(function(property){
    if(property.class == propertyClass && property.channel ==  channelId && property.component === componentId){
      _property = property.id;
      return _property;
    }
  });
  return _property;
}

/**
  Get property data by the channel, component and class.
**/
ChannelsHelper.prototype.getPropertyByComponent = function(componentId, channelId, propertyClass){
  var properties = this.properties;
  var _property=null;
  properties.forEach(function(property){
    if(property.class == propertyClass && property.component === componentId && property.channel === channelId){
      _property = property;
      return _property;
    }
  });
  return _property;
}

/**
  Get property data.
**/
ChannelsHelper.prototype.getPropertyByClass = function(propertyClass){
  var properties = this.properties;
  var _property=[];
  properties.forEach(function(property){
    if(property.class == propertyClass){
      _property.push(property);
      return _property;
    }
  });
  return _property;
}

/*
  Set object to publish.
*/
ChannelsHelper.prototype.publishPropertie = function(io, property, value, channelId, profileId, componentId){
  var object;
  switch(io){
    case 'read':
      if(value !== null){
        object = {
          namespace: 'iot',
          payload: {
            io: 'r', profile: profileId, channel: channelId, property: property, component: componentId,
            data: {
              value : value
            }
          }
        };
      }else{
        object = {
          namespace: 'iot',
          payload: {
            io: 'r', profile: profileId, channel: channelId, property: property, component: componentId
          }
        };
      }
      
    break;
    case 'write':
      object = {
        namespace: 'iot',
        payload: {
          io: 'w', profile: profileId, channel: channelId, property: property, component: componentId,
          data: {
            value : value
          }
        }
      };
    break;
  }
  return object;
}

/**
  Private function.
  Returns the ids of the components thats include the property.
**/
function getComponentsIdByType(existingComponents, propertyComponent){
  var ids=[];
  existingComponents.forEach(function(eComponent){
    for(var i=0; i<propertyComponent.length; i++){
      if(eComponent.type === propertyComponent[i]){
        ids.push(eComponent.id);
      }
    }
  });
  return ids;
}

/**
  Private function.
  Returns the schema supported by the class.
**/
function getSupportedSchemaByClass(classs, supportedClasses){ 
  var schema = [];
  supportedClasses.forEach(function(supportedClass){
    if(supportedClass.class === classs){
      schema = supportedClass.schema;
      return schema;
    }
  });
  return schema;
}

function checkSchema(schema){
  if(typeof schema !== 'string'){ 
    if(self.debug){ console.log("Schema isn't a string"); }
    if(self.alerts){ alert("Schema isn't a string"); }
    return schema; 
  }
  schema = schema.substring(schema.indexOf('/'), schema.length);
  return schema;
}

function removeDuplicatedClasses(properties, allClasses){
  var duplicated = getDuplicatedClasses(properties);
  var propertyToDelete = [];
  duplicated.forEach(function(duplicatedProperty){
    properties.forEach(function(property){
      if(duplicatedProperty.id === property.id && property.class !== duplicatedProperty.class){
        propertyToDelete.push(duplicatedProperty);
        return propertyToDelete;
      }
    });
  });
  if(debug){ console.log('Found '+propertyToDelete.length+' duplicated classes to delete'); }
  propertyToDelete.forEach(function(toDelete){
    remove(properties, toDelete);
  });
  return properties;
}

function remove(arr, item) {
  for(var i = arr.length; i--;) {
    if(arr[i] === item) {
        arr.splice(i, 1);
    }
  }
}

function getDuplicatedClasses(properties){
  var duplicated=[];
  var classes = [];
  properties.forEach(function(property){
    classes.push(property.class);
  });
  var occurences=0;
  var duplicatedCl=[];
  classes.forEach(function(classs){
    occurences = getOccurencesNumber(classes, classs);
    if(occurences > 1 && duplicatedCl.indexOf(classs) === -1){
      duplicatedCl.push(classs);
    }
  });
  duplicatedCl.forEach(function(classs){
    properties.forEach(function(property){
      if(property.class === classs){
        duplicated.push(property);
        return;
      }
    });
  });
  return duplicated;
}

function getOccurencesNumber(classesArray, classToSearch){
  var number= 0;
  classesArray.forEach(function(classs){
    if(classs === classToSearch){
      number++;
    }
  });
  return number;
}
